/*
*   \file
*   \remarks Secure Store (DRM Core) APIs Prototypes
*   \author Pavel Haber
*
*   WMDRM Service Package, Type Definitions, Secure Store (DRM Core)
*
*   Copyright (C) 2007 by Discretix Technologies Ltd.
*           All rights reserved.
*
*/

#ifndef SECSTORE_TST_API_H
#define SECSTORE_TST_API_H

DRM_RESULT SST_PreTestCase(long lTCID, char *strTCName);
DRM_RESULT SST_PostTestCase(long lTCID, char *strTCName);

DRM_RESULT TestDRM_SST_Initialize(long iIndex, char **argv);
DRM_RESULT TestDRM_SST_GetData(long argc, char **argv);
DRM_RESULT TestDRM_SST_SetData(long argc, char **argv);
DRM_RESULT TestDRM_SST_OpenKeyTokens(long argc, char **argv);
DRM_RESULT TestDRM_SST_GetTokenValue(long argc, char **argv);
DRM_RESULT TestDRM_SST_SetTokenValue(long argc, char **argv);
DRM_RESULT TestDRM_SST_GetAllData(long argc, char **argv);
DRM_RESULT TestDRM_SST_CloseKey(long argc, char **argv);
DRM_RESULT TestDRM_SST_DeleteKey(long argc, char **argv);
DRM_RESULT TestDRM_SST_OpenEnumerator(long argc, char **argv);
DRM_RESULT TestDRM_SST_EnumNext(long argc, char **argv);
DRM_RESULT TestDRM_SST_CreateGlobalStorePassword(long argc, char **argv);
DRM_RESULT TestDRM_SST_CreateLicenseStatePassword(long argc, char **argv);
DRM_RESULT TestDRM_SST_OpenAndLockSlot(long argc, char **argv);
DRM_RESULT TestDRM_SST_SetLockedData(long argc, char **argv);
DRM_RESULT TestDRM_SST_GetLockedData(long argc, char **argv);
DRM_RESULT TestDRM_SST_CloseLockedSlot(long argc, char **argv);

#endif

